package jamezo97.clonecraft.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import jamezo97.clonecraft.CloneCraft;
import jamezo97.clonecraft.GuiHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class BlockGeneExtractor extends BlockContainer{

	
	public BlockGeneExtractor(int par1) {
		super(par1, Material.rock);
		this.setTextureName("CloneCraft:extractorFront");
	}
	
	@Override
	public TileEntity createNewTileEntity(World world) {
		return new TileEntityGeneExtractor();
	}
	
	Icon top;

	@Override
	public void registerIcons(IconRegister ir) {
		super.registerIcons(ir);
		top = ir.registerIcon("CloneCraft:extractorTop");
	}
	
	@SideOnly(Side.CLIENT)

    /**
     * From the specified side and block metadata retrieves the blocks texture. Args: side, metadata
     */
    public Icon getIcon(int par1, int par2)
    {
        return par1 == 1 ? this.top : (par1 == 0 ? CloneCraft.sterilizer.getDefaultSideIcon() : (par1 != par2 ? CloneCraft.sterilizer.getDefaultSideIcon() : this.blockIcon));
    }

	/**
     * Called when the block is placed in the world.
     */
    public void onBlockPlacedBy(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack)
    {
        int l = MathHelper.floor_double((double)(par5EntityLivingBase.rotationYaw * 4.0F / 360.0F) + 0.5D) & 3;

        if (l == 0)
        {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 2, 2);
        }

        if (l == 1)
        {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 5, 2);
        }

        if (l == 2)
        {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 3, 2);
        }

        if (l == 3)
        {
            par1World.setBlockMetadataWithNotify(par2, par3, par4, 4, 2);
        }

        if (par6ItemStack.hasDisplayName())
        {
            ((TileEntityFurnace)par1World.getBlockTileEntity(par2, par3, par4)).setGuiDisplayName(par6ItemStack.getDisplayName());
        }
    }
    
    private void setDefaultDirection(World par1World, int par2, int par3, int par4)
    {
        if (!par1World.isRemote)
        {
            int l = par1World.getBlockId(par2, par3, par4 - 1);
            int i1 = par1World.getBlockId(par2, par3, par4 + 1);
            int j1 = par1World.getBlockId(par2 - 1, par3, par4);
            int k1 = par1World.getBlockId(par2 + 1, par3, par4);
            byte b0 = 3;

            if (Block.opaqueCubeLookup[l] && !Block.opaqueCubeLookup[i1])
            {
                b0 = 3;
            }

            if (Block.opaqueCubeLookup[i1] && !Block.opaqueCubeLookup[l])
            {
                b0 = 2;
            }

            if (Block.opaqueCubeLookup[j1] && !Block.opaqueCubeLookup[k1])
            {
                b0 = 5;
            }

            if (Block.opaqueCubeLookup[k1] && !Block.opaqueCubeLookup[j1])
            {
                b0 = 4;
            }

            par1World.setBlockMetadataWithNotify(par2, par3, par4, b0, 2);
        }
    }

	@Override
	public void breakBlock(World par1World, int par2, int par3, int par4, int par5, int par6) {
		TileEntity te = par1World.getBlockTileEntity(par2, par3, par4);
		if(te != null && te instanceof IInventory){
			IInventory inven = (IInventory)te;
			for(int a = 0; a < inven.getSizeInventory(); a++){
				ItemStack stack = inven.getStackInSlot(a);
				if(stack != null){
					EntityItem item = new EntityItem(par1World, par2+.5, par3+.5, par4+.5, stack);
					item.delayBeforeCanPickup = 10;
					par1World.spawnEntityInWorld(item);
				}
			}
			/*if(te instanceof TileEntityChromosomeExtractor){
				((TileEntityChromosomeExtractor)te).onBroken();
			}*/
		}
		
		super.breakBlock(par1World, par2, par3, par4, par5, par6);
	}


	@Override
	public boolean onBlockActivated(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
		par5EntityPlayer.openGui(CloneCraft.instance, GuiHandler.GENEEXTRACTOR, par1World, par2, par3, par4);
		return true;
	}


}
